---------------------------------------------------------------------------------------------------------------------------------
--Work Item 618266 Add Comment text area and/or functionality to all survey fields
---------------------------------------------------------------------------------------------------------------------------------

/****** Object:  StoredProcedure [CRS].[usp_SURVEY_RESULTS_save]    Script Date: 12/8/2017 10:01:48 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_SURVEY_RESULTS_save]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_SURVEY_RESULTS_save]
GO

/****** Object:  StoredProcedure [CRS].[usp_SURVEY_RESULTS_save]    Script Date: 12/8/2017 10:01:48 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_SURVEY_RESULTS_save]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'
-- =============================================
-- Author:        
-- Create date:   05/06/2016
-- Description:   Save/Update a record
-- =============================================
CREATE PROCEDURE [CRS].[usp_SURVEY_RESULTS_save] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @CREATED datetime, @CREATEDBY varchar(30), @RESULT_TEXT varchar(max), @SELECTED_FLAG bit, @STD_QUESTION_CHOICE_ID int, @STD_QUESTION_ID int, @SURVEY_RESULT_ID int output, @SURVEYS_ID int, @UPDATED datetime, @UPDATEDBY varchar(30))
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_SURVEY_RESULTS_save'', @ErrorMsg, ''User is not part of this Registry'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SET @CREATED = GetDate();
	SET @UPDATED = GetDate();
	SET @CREATEDBY = @CURRENT_USER;
	SET @UPDATEDBY = @CURRENT_USER;

	IF ISNULL(@SURVEY_RESULT_ID,0) = 0
		BEGIN
			INSERT INTO [CRS].[SURVEY_RESULTS] ([CREATED], [CREATEDBY], [RESULT_TEXT],[SELECTED_FLAG], [STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [SURVEYS_ID], [UPDATED], [UPDATEDBY])
			VALUES (@CREATED, @CREATEDBY, @RESULT_TEXT, @SELECTED_FLAG, @STD_QUESTION_CHOICE_ID, @STD_QUESTION_ID, @SURVEYS_ID, @UPDATED, @UPDATEDBY);
			SELECT @SURVEY_RESULT_ID = SCOPE_IDENTITY();
		END
	ELSE
		BEGIN
			DECLARE @OldValues varchar(max), @NewValues varchar(max);
			SELECT @OldValues = ''<CREATED>'' + ISNULL(CAST([CREATED] AS varchar), '''') + ''</CREATED><CREATEDBY>'' + ISNULL(CAST([CREATEDBY] AS varchar), '''') + ''</CREATEDBY><RESULT_TEXT>'' + ISNULL(CAST([RESULT_TEXT] AS varchar), '''') + ''</RESULT_TEXT><SELECTED_FLAG>'' + ISNULL(CAST([SELECTED_FLAG] AS varchar), '''') + ''</SELECTED_FLAG><STD_QUESTION_CHOICE_ID>'' + ISNULL(CAST([STD_QUESTION_CHOICE_ID] AS varchar), '''') + ''</STD_QUESTION_CHOICE_ID><STD_QUESTION_ID>'' + ISNULL(CAST([STD_QUESTION_ID] AS varchar), '''') + ''</STD_QUESTION_ID><SURVEY_RESULT_ID>'' + ISNULL(CAST([SURVEY_RESULT_ID] AS varchar), '''') + ''</SURVEY_RESULT_ID><SURVEYS_ID>'' + ISNULL(CAST([SURVEYS_ID] AS varchar), '''') + ''</SURVEYS_ID><UPDATED>'' + ISNULL(CAST([UPDATED] AS varchar), '''') + ''</UPDATED><UPDATEDBY>'' + ISNULL(CAST([UPDATEDBY] AS varchar), '''') + ''</UPDATEDBY>'' FROM [CRS].[SURVEY_RESULTS] WHERE [SURVEY_RESULT_ID] = @SURVEY_RESULT_ID;
			SELECT @NewValues = ''<CREATED>'' + ISNULL(CAST(@CREATED AS varchar), '''') + ''</CREATED><CREATEDBY>'' + ISNULL(CAST(@CREATEDBY AS varchar), '''') + ''</CREATEDBY><RESULT_TEXT>'' + ISNULL(CAST(@RESULT_TEXT AS varchar), '''') + ''</RESULT_TEXT><SELECTED_FLAG>'' + ISNULL(CAST(@SELECTED_FLAG AS varchar), '''') + ''</SELECTED_FLAG><STD_QUESTION_CHOICE_ID>'' + ISNULL(CAST(@STD_QUESTION_CHOICE_ID AS varchar), '''') + ''</STD_QUESTION_CHOICE_ID><STD_QUESTION_ID>'' + ISNULL(CAST(@STD_QUESTION_ID AS varchar), '''') + ''</STD_QUESTION_ID><SURVEY_RESULT_ID>'' + ISNULL(CAST(@SURVEY_RESULT_ID AS varchar), '''') + ''</SURVEY_RESULT_ID><SURVEYS_ID>'' + ISNULL(CAST(@SURVEYS_ID AS varchar), '''') + ''</SURVEYS_ID><UPDATED>'' + ISNULL(CAST(@UPDATED AS varchar), '''') + ''</UPDATED><UPDATEDBY>'' + ISNULL(CAST(@UPDATEDBY AS varchar), '''') + ''</UPDATEDBY>'';
			SELECT @ErrorMsg = ''[CRS].[SURVEY_RESULTS] values have been updated (Old Values:'' + @OldValues + '') to (New Values:'' + @NewValues + '') by ('' + @CURRENT_USER + '')'';
			EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_SURVEY_RESULTS_save'', @ErrorMsg, NULL, @CURRENT_USER;

			UPDATE [CRS].[SURVEY_RESULTS] 
			SET
				[RESULT_TEXT] = @RESULT_TEXT
				, [SELECTED_FLAG] = @SELECTED_FLAG
				, [STD_QUESTION_CHOICE_ID] = @STD_QUESTION_CHOICE_ID
				, [STD_QUESTION_ID] = @STD_QUESTION_ID
				, [SURVEYS_ID] = @SURVEYS_ID
				, [UPDATED] = @UPDATED
				, [UPDATEDBY] = @UPDATEDBY
			WHERE
				[SURVEY_RESULT_ID] = @SURVEY_RESULT_ID;
		END
END' 

END
GO


---------------------------------------------------------------------------------------------------------------------------------
--Work Item 618249 Add Functionality to display Framework data details
---------------------------------------------------------------------------------------------------------------------------------

/****** Object:  StoredProcedure [CRS].[usp_VITALSIGN_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_VITALSIGN_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_VITALSIGN_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_TIU_TIUDOCUMENT_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_TIU_TIUDOCUMENT_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_TIU_TIUDOCUMENT_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_SPATIENT_SPATIENTINSURANCE_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_SPATIENT_SPATIENTINSURANCE_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_SPATIENT_SPATIENTINSURANCE_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_SPATIENT_NEW_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_SPATIENT_NEW_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_SPATIENT_NEW_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_SERVICE_CONNECTED_CONDITION_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_SERVICE_CONNECTED_CONDITION_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_SERVICE_CONNECTED_CONDITION_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_SCONSULT_REASON_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_SCONSULT_REASON_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_SCONSULT_REASON_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_RXOUTPAT_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_RXOUTPAT_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_RXOUTPAT_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_RADIOLOGYEXAM_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_RADIOLOGYEXAM_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_RADIOLOGYEXAM_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_PHARMACY_PATIENT_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_PHARMACY_PATIENT_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_PHARMACY_PATIENT_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_PATSUB_VARATEDDISABILITY_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_PATSUB_VARATEDDISABILITY_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_PATSUB_VARATEDDISABILITY_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_PATSUB_SECONDARYELIGIBILITY_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_PATSUB_SECONDARYELIGIBILITY_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_PATSUB_SECONDARYELIGIBILITY_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_PATIENT_ETHNICITY_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_PATIENT_ETHNICITY_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_PATIENT_ETHNICITY_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_PATIENT_ENROLLMENT_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_PATIENT_ENROLLMENT_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_PATIENT_ENROLLMENT_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_OUTPAT_VDIAGNOSIS_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_OUTPAT_VDIAGNOSIS_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_OUTPAT_VDIAGNOSIS_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_OUTPAT_PROBLEMLIST_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_OUTPAT_PROBLEMLIST_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_OUTPAT_PROBLEMLIST_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_OEFOIF_SERVICE_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_OEFOIF_SERVICE_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_OEFOIF_SERVICE_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_NOSETHROAT_RADIUMHST_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_NOSETHROAT_RADIUMHST_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_NOSETHROAT_RADIUMHST_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_MILITARY_SEXUAL_TRAUMA_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_MILITARY_SEXUAL_TRAUMA_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_MILITARY_SEXUAL_TRAUMA_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_MILITARY_SERVICE_EPISODE_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_MILITARY_SERVICE_EPISODE_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_MILITARY_SERVICE_EPISODE_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_INPATIENT_DIAGNOSIS_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_INPATIENT_DIAGNOSIS_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_INPATIENT_DIAGNOSIS_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_INPAT_INPATIENT_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_INPAT_INPATIENT_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_INPAT_INPATIENT_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_INPAT_CENSUS_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_INPAT_CENSUS_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_INPAT_CENSUS_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_Immunization_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_Immunization_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_Immunization_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_EDISLOG_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_EDISLOG_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_EDISLOG_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_Consult_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_Consult_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_Consult_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_CHEM_LABCHEM_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_CHEM_LABCHEM_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_CHEM_LABCHEM_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_ALLERGY_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_ALLERGY_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_ALLERGY_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_A06_SPATIENT_GEOCODEDADDRESS_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_A06_SPATIENT_GEOCODEDADDRESS_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_A06_SPATIENT_GEOCODEDADDRESS_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_A06_PHARMACY_PATX_NONVA_MEDS_55_05_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_A06_PHARMACY_PATX_NONVA_MEDS_55_05_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_A06_PHARMACY_PATX_NONVA_MEDS_55_05_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_A06_PHARMACY_PATIX_UNIT_DOSE_55_06_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_A06_PHARMACY_PATIX_UNIT_DOSE_55_06_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_A06_PHARMACY_PATIX_UNIT_DOSE_55_06_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_A06_PHARMACY_PATIENT_55X_IV_55_01_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_A06_PHARMACY_PATIENT_55X_IV_55_01_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_A06_PHARMACY_PATIENT_55X_IV_55_01_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_A06_AUDIOMETRIC_EXAM_DATA_509850_9_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_A06_AUDIOMETRIC_EXAM_DATA_509850_9_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_A06_AUDIOMETRIC_EXAM_DATA_509850_9_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_REGISTRY_FRAMEWORK_DATA_getitemsByRegistry]    Script Date: 12/8/2017 9:48:02 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_REGISTRY_FRAMEWORK_DATA_getitemsByRegistry]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_REGISTRY_FRAMEWORK_DATA_getitemsByRegistry]
GO